define(
    [
		'jquery',
		'Magento_Payment/js/view/payment/cc-form',
        'underscore',
        'Magento_Customer/js/customer-data',
        'Magento_Payment/js/model/credit-card-validation/credit-card-data',
        'Magento_Payment/js/model/credit-card-validation/credit-card-number-validator',
		'CreditCardTypes',
        'jquery/ui',
        'mage/translate'
    ],
    function ($, Component,_,customerData,creditCardData,cardNumberValidator,creditCardTypes) {
        'use strict';
        return Component.extend({
            defaults: {
                template: 'ZS_Usaepay/payment/usaepay-form',
				creditCardToken: null,
                errorMessage: null,
                truncatedCreditCardNumber: null,
                savedCards: [],
                selectedCard: null
            },
            getCode: function() {
                return 'zs_usaepay';
            },
			initObservable: function() {
                var self = this;
                this._super()
                    .observe([
                        'saveCard',
                        'selectedCard',
                        'creditCardToken',
                        'errorMessage',
                        'truncatedCreditCardNumber'
                    ]);
					
                this.creditCardNumber.subscribe(function(value) {
                    self.truncatedCreditCardNumber(self.truncate(value));
                });
                this.selectedCard.subscribe(function(value) {
                    if (typeof value !== 'undefined') {
                        // Card was selected
                        var cardType = _.find(creditCardTypes, function(type) {
                            return type.type === value.extendedData.card_type;
                        });
                        if (!cardType) {
                            return;
                        }
                        creditCardData.creditCard = cardType;
                    }
                });
                return this;
            },	
				
			beforePlaceOrder: function(data, event) {
                var self = this, ccMonth, ccYear;

                if (!this.validate()) {
                    return false;
                }

                /**
                 * Do we need to tokenize this card?
                 */
                if (window.checkoutConfig.payment[this.getCode()].isTokenizationEnabled && !this.selectedCard()) {
                    ccMonth = this.creditCardExpMonth().padStart(2, '0');
                    ccYear = this.creditCardExpYear().substring(2, 4);

                    Mes.tokenize(this.creditCardNumber(), ccMonth + ccYear, function(result) {
                        if (self.onMesTokenResponse(result)) {
                            return self.placeOrder(data, event);
                        }
                    });
                } else {
                    this.placeOrder(data, event);
                }
            },
			
			truncate: function(number) {
                return  (number.length > 4 ? "*".repeat(number.length - 4) : '') + number.substring(number.length - 4, number.length)
            },
			
            isActive: function() {
                return true;
            },
            /**
             * @override
             */
            initialize: function() {
                var self = this;
                this._super();

                //Set credit card number to credit card data object
                this.creditCardNumber.subscribe(function(value) {
                    var result;
                    self.selectedCardType(null);

                    if (value == '' || value == null) {
                        return false;
                    }
                    result = cardNumberValidator(value);

                    if (!result.isPotentiallyValid && !result.isValid) {
                        var GCRegExp = /^([0-9]{19})$/;
                        if (GCRegExp.test(value)) {
                            result.isValid = true;
                            result.isPotentiallyValid = true;
                            result.card = {
                                type: 'GC',
                                title: 'Gift Card',
                                pattern: GCRegExp,
                                lengths: [19]
                            }
                        }
                    }

                    if (!result.isPotentiallyValid && !result.isValid) {
                        return false;
                    }
                    if (result.card !== null) {
                        self.selectedCardType(result.card.type);
                        creditCardData.creditCard = result.card;
                    }

                    if (result.isValid) {
                        creditCardData.creditCardNumber = value;
                        self.creditCardType(result.card.type);
                    }
                });

                //Set expiration year to credit card data object
                this.creditCardExpYear.subscribe(function(value) {
                    creditCardData.expirationYear = value;
                });

                //Set expiration month to credit card data object
                this.creditCardExpMonth.subscribe(function(value) {
                    creditCardData.expirationYear = value;
                });

                //Set cvv code to credit card data object
                this.creditCardVerificationNumber.subscribe(function(value) {
                    creditCardData.cvvCode = value;
                });
            },
            
            /**
             * @override
             */
            getIcons: function(type) {
                if (type == 'GC') {
                    var iconObject = window.checkoutConfig.payment.ccform.icons['VI'];
                    iconObject.url = iconObject.url.replace('Magento_Payment', 'ZS_Usaepay').replace('vi.png', 'gc.png');
                    return iconObject;
                } else {
                    return window.checkoutConfig.payment.ccform.icons.hasOwnProperty(type)
                        ? window.checkoutConfig.payment.ccform.icons[type]
                        : false
                }
            },
            
            /**
             * @override
             */
            validate: function () {
				if(this.selectedCard()){
					if(this.selectedCard().cardId){
						if(this.forceCvvForSavedCards()){
							if(this.validateCVV()){
								return true;
							} else {
								return false;
							}
						}
						return true;
					} else {
						return false;
					}
				} else { 
					if (
						this.validateCCNumber() &
						this.validateCVV() &
						this.validateExpirationMonth() &
						this.validateExpirationYear()
					) {
						return true;
					} else {
						return false;
					}
				}
            },
            
            validateExpirationMonth: function () {
                var validate = false;
                if (this.selectedCardType() == 'GC') {
                    validate = true;
                } else {
                    var $element = $('#zs_usaepay_expiration');
                    validate = $element.val();
                }
                return this._validationMessage('zs_usaepay_expiration', validate, 'This is a required field.');
            },
            
            validateExpirationYear: function () {
                var validate = false;
                if (this.selectedCardType() == 'GC') {
                    validate = true;
                } else {
                    var $element = $('#zs_usaepay_expiration_yr');
                    validate = $element.val();
                }
                return this._validationMessage('zs_usaepay_expiration_yr', validate, 'This is a required field.');
            },
            
            validateCVV: function () {
                var validate = false;
                if (this.selectedCardType() == 'GC') {
                    validate = true;
                } else {
                    var $element = $('#zs_usaepay_cc_cid');
                    var numericReg = /^\d+$/;
                    validate = numericReg.test($element.val());
                }
                return this._validationMessage('zs_usaepay_cc_cid', validate, 'Please enter a valid number in this field.');
            },
            
            validateCCNumber: function () {
                var $element = $('#zs_usaepay_cc_number');
                var value = $element.val();
                
                var CCTypes = {
                    'VI': new RegExp('^4[0-9]{12}([0-9]{3})?$'),
                    'MC': new RegExp('^(?:5[1-5][0-9]{2}|222[1-9]|22[3-9][0-9]|2[3-6][0-9]{2}|27[01][0-9]|2720)[0-9]{12}$'),
                    'AE': new RegExp('^3[47][0-9]{13}$'),
                    'DI': new RegExp('^(30[0-5][0-9]{13}|3095[0-9]{12}|35(2[8-9][0-9]{12}|[3-8][0-9]{13})|36[0-9]{12}|3[8-9][0-9]{14}|6011(0[0-9]{11}|[2-4][0-9]{11}|74[0-9]{10}|7[7-9][0-9]{10}|8[6-9][0-9]{10}|9[0-9]{11})|62(2(12[6-9][0-9]{10}|1[3-9][0-9]{11}|[2-8][0-9]{12}|9[0-1][0-9]{11}|92[0-5][0-9]{10})|[4-6][0-9]{13}|8[2-8][0-9]{12})|6(4[4-9][0-9]{13}|5[0-9]{14}))$'),
                    'GC': new RegExp('^([0-9]{19})$')
                };
                
                var CCNumberType = false;
                $.each(CCTypes, function (type, exp){
                    if (exp.test(value)) {
                        CCNumberType = type;
                        return false;
                    }
                });

                return this._validationMessage('zs_usaepay_cc_number', CCNumberType, 'Please enter a valid credit card type number.');
            }, 
            
            _validationMessage: function (elementId, validate, message) {
                var $element = $('#' + elementId);
                if (!validate) {
                    if (!$element.hasClass('mage-error')) {
                        $element.addClass('mage-error');
                    }
                    if (!$('#' + elementId + '-error').length) {
                        $element.after('<div for="' + elementId + '" generated="true" class="mage-error" id="' + elementId + '-error">' + message + '</div>');
                    }
                    return false;
                } else {
                    if ($element.hasClass('mage-error')) {
                        $element.removeClass('mage-error');
                    }
                    if ($('#' + elementId + '-error').length) {
                        $('#' + elementId + '-error').remove();
                    }
                    return true;
                }
            },
			canSaveCard: function() {
                return window.checkoutConfig.payment[this.getCode()].canSaveCard;
            },

            getSavedCards: function() {
                return window.checkoutConfig.payment[this.getCode()].savedCards;
            },

            forceCvvForSavedCards: function() {
                return window.checkoutConfig.payment[this.getCode()].forceCvv;
            },
			getData: function() {
                var data 							= this._super();
                data.method 						= this.item.method;
                data.additional_data["cc_token"] 	= this.creditCardToken();
                data.additional_data["card_id"] 	= this.selectedCard() ? this.selectedCard().cardId : null;
                data.additional_data["save_card"] 	= this.saveCard();
                if (data.additional_data["cc_token"]) {
                    data.additional_data["cc_number"] = this.truncatedCreditCardNumber();
                }
                return data;
            },
            hasVerification: function() {
                return (!this.selectedCard() && window.checkoutConfig.payment.ccform.hasVerification[this.getCode()]) || (this.selectedCard() && this.forceCvvForSavedCards());
            },
        });
    }
);